define([
    'underscore',
    'marionette',
    'moment',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-collection',

    'text!modules/new-appointment-request/views/direct/preferred-date/templates/date-collapsible.html',
    'text!modules/new-appointment-request/views/direct/preferred-date/templates/date-collapsible-expanded.html',
    'modules/new-appointment-request/views/direct/preferred-date/time-button',
],
function(
    _,
    Marionette,
    moment,
    TimeSlotsCollection,

    dateTemplate,
    dateExpandedTemplate,
    TimeButtonView
) {
    'use strict';


    var ARIA_DATE_FORMAT = 'MMMM DD YYYY';
    var SELECTOR_DATE_FORMAT = 'MM-DD-YYYY';
    var ENTER_KEY = 13;

    // reduces rendering time with prerendered collapsible;
    // given this.model (with date and timeSlots),
    // create this.collection and show child views on expand
    return Marionette.CompositeView.extend({
        attributes: {
            'data-role': 'collapsible',
            'data-enhanced': 'true',
        },
        events: {
            'click .ui-collapsible-heading': 'toggleCollapsible',
            'keydown .ui-collapsible-heading': 'toggleCollapsibleOnKeydown',
        },
        className: 'ui-collapsible ui-collapsible-themed-content',
        template: dateTemplate,
        childViewContainer: '.ui-collapsible-content',
        childView: TimeButtonView,
        initialize: function(options) {
            if (_.isUndefined(this.collection)) {
                this.collection = new TimeSlotsCollection();
            }
            this._collapsed = _.isUndefined(options.collapsed) ? true : options.collapsed;
            this._isToggled = false;

            if (this._collapsed) {
                this.className += ' ui-collapsible-collapsed';
                this.el.className = this.className;
                // adds timeslots only when collapsible is expanded
                this.$el.on('collapsibleexpand', this.updateTimeSlots.bind(this));
            } else {
                this.template = dateExpandedTemplate;
                this.updateTimeSlots();
            }
        },
        updateTimeSlots: function() {
            if (this.collection.length === 0) {
                this.collection.add(this.model.get('timeSlots').models);
            }
        },
        templateContext: function() {
            var date = this.model.get('date');
            var ariaLabel = moment(date).format(ARIA_DATE_FORMAT);

            return {ariaLabel: ariaLabel};
        },
        toggleCollapsible: function() {
            var formattedDate = moment(this.model.get('date')).format(SELECTOR_DATE_FORMAT);
            var availableTimeSlotSelectorString = '#available-slots-on-' + formattedDate;

            var availableTimeSlots = $(availableTimeSlotSelectorString + ' + .available-time-slots');
            var toggleButton = $(availableTimeSlotSelectorString + ' > .ui-collapsible-heading-toggle');
            var collapsibleHeading = $(availableTimeSlotSelectorString + ' .ui-collapsible-heading-status');

            this._isToggled = !this._isToggled;

            if (this._isToggled) {
                availableTimeSlots.css({
                    display: 'none',
                });

                collapsibleHeading.html(moment().format(ARIA_DATE_FORMAT) + ' select to expand content');

                this.className += ' ui-collapsible-collapsed';
                this.el.className = this.className;

                toggleButton.removeClass('ui-icon-carat-d').addClass('ui-icon-carat-r');
            } else {
                availableTimeSlots.css({
                    display: '',
                });

                collapsibleHeading.html(moment().format(ARIA_DATE_FORMAT) + ' select to collapse content');

                this.className = this.className.replace(' ui-collapsible-collapsed', '');
                this.el.className = this.className;

                toggleButton.removeClass('ui-icon-carat-r').addClass('ui-icon-carat-d');
            }
        },
        toggleCollapsibleOnKeydown: function(e) {
            if (e.which === ENTER_KEY && $('.available-dates').length === 1) {
                e.preventDefault();
                this.toggleCollapsible();

                return;
            }
        },
    });
});
